<?php
/*--------------------------------------------------------------------
 ReaderInterface.php 2020-06-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Repository\Readers;

use Gambio\Shop\Properties\SellingUnitModel\Database\Exceptions\PropertiesCombinationIdDoesNotExistException;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\PropertiesCombinationIdDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\CombinationModelDto;

/**
 * Interface ReaderInterface
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Repository\Readers
 */
interface ReaderInterface
{
    /**
     * @param PropertiesCombinationIdDto $combinationIdDto
     *
     * @return CombinationModelDto
     * @throws PropertiesCombinationIdDoesNotExistException
     */
    public function combinationModel(PropertiesCombinationIdDto $combinationIdDto): CombinationModelDto;
}